/* 
 * File: I2C.h
 * Author: LaV
 * Comments:
 * Revision history: 1
 */
#ifndef I2C_H
#define	I2C_H

#include <xc.h>
#include <pic18f452.h>
#include "init.h"

void I2C_Idle();//проверка состояния линии  
void I2C_Start();//формирование стартового бита
void I2C_ReStart();//формирование повторного стартового бита
void I2C_Stop();//Формирование стопового бита
void I2C_NotAck();//подтверждение не формируется
void I2C_AckPoll();//Запрос готовности микросхемы
void I2C_AckWait();//ожидание готовности slave-микросхемы
void I2C_AckChek();//проверка приема slave-микросхемой
void I2C_Write_byte(unsigned char h_addr, unsigned char l_addr, unsigned char data_I2C);//Запись 1-го байта
void I2C_Delete_page(unsigned char h_addr, unsigned char l_addr);//удалить(перезаписать 0xFF) страницу (128 байт)
void I2C_Delete_all();//стереть микросхему полностью
void I2C_Write_3byte(unsigned char h_addr, unsigned char l_addr, unsigned char data_I2C, unsigned char data1_I2C, unsigned char data2_I2C);////Запись 3-х байт
void I2C_Write(unsigned char data_I2C);//функция записи 
unsigned char I2C_Read(unsigned char h_addr, unsigned char l_addr);//функция чтения 1-го байта
void I2C_Read_3byte(unsigned char h_addr, unsigned char l_addr);//функция чтения 3-х байт
void I2C_card_search_p(void);//постраничный поиск
void I2C_card_search(void);//поиск, чтением по 3 байта

#endif
